<?php
require_once 'koneksi.php';

// Get the POST data
$postData = file_get_contents("php://input");
$request = json_decode($postData, true);

// Check if all required fields are present
if (isset($request['temperature']) && isset($request['humidity'])) {
    $temperature = $request['temperature'];
    $humidity = $request['humidity'];

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO tb_sensor (temperature, humidity) VALUES (?, ?)");
    $stmt->bind_param("ff", $temperature, $humidity);

    // Execute the statement
    if ($stmt->execute()) {
        // Insert successful
        $response = array(
            "status" => true,
            "message" => "Data sensor berhasil ditambahkan",
            "id" => $stmt->insert_id
        );
    } else {
        // Insert failed
        $response = array(
            "status" => false,
            "message" => "Gagal menambahkan data sensor"
        );
    }

    // Close the statement
    $stmt->close();
} else {
    // If any of the required fields are not set in the request
    $response = array(
        "status" => false,
        "message" => "Temperature dan humidity harus diisi"
    );
}

// Set the response header to JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the connection
$conn->close();
?>