<?php
require_once 'koneksi.php';

// Get the ID from the URL
$id = isset($_GET['id']) ? $_GET['id'] : die(json_encode(array(
    "status" => false,
    "message" => "ID sensor harus disertakan"
)));

// Prepare and bind
$stmt = $conn->prepare("DELETE FROM tb_sensor WHERE id = ?");
$stmt->bind_param("i", $id);

// Execute the statement
if ($stmt->execute()) {
    // Delete successful
    $response = array(
        "status" => true,
        "message" => "Data sensor berhasil dihapus"
    );
} else {
    // Delete failed
    $response = array(
        "status" => false,
        "message" => "Gagal menghapus data sensor"
    );
}

// Close the statement
$stmt->close();

// Set the response header to JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the connection
$conn->close();
?>