<?php
require_once 'koneksi.php';

// Get the ID from the URL
$id = isset($_GET['id']) ? $_GET['id'] : die(json_encode(array(
    "status" => false,
    "message" => "ID sensor harus disertakan"
)));

// Get the POST data
$postData = file_get_contents("php://input");
$request = json_decode($postData, true);

// Check if all required fields are present
if (isset($request['temperature']) && isset($request['humidity'])) {
    $temperature = $request['temperature'];
    $humidity = $request['humidity'];

    // Prepare and bind
    $stmt = $conn->prepare("UPDATE tb_sensor SET temperature = ?, humidity = ? WHERE id = ?");
    $stmt->bind_param("ffi", $temperature, $humidity, $id);

    // Execute the statement
    if ($stmt->execute()) {
        // Update successful
        $response = array(
            "status" => true,
            "message" => "Data sensor berhasil diperbarui"
        );
    } else {
        // Update failed
        $response = array(
            "status" => false,
            "message" => "Gagal memperbarui data sensor"
        );
    }

    // Close the statement
    $stmt->close();
} else {
    // If any of the required fields are not set in the request
    $response = array(
        "status" => false,
        "message" => "Temperature dan humidity harus diisi"
    );
}

// Set the response header to JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the connection
$conn->close();
?>